<!DOCTYPE HTML>

<?php
    // function to allow easy insertion of gallery code
    include("functions.php");
?>

<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="description" content="Benny's BarberShop"> 
    <meta name="keywords" content="Benny's BarberShop, images, gallery">
    <meta name="author" content="Mr N Panapa">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">

    <title>Benny's BarberShop</title>

    <!-- Edit the link below / replace with your chosen google font -->
    <link href="https://fonts.googleapis.com/css?family=Lato%7cUbuntu" rel="stylesheet">

    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/simple-lightbox.css">
    <link rel="stylesheet" href="css/gallery.css">

    <!-- Edit the name of your style sheet 'foo' is not a valid name!! -->
    <link rel="stylesheet" href="css/layout.css">
    <link rel="stylesheet" href="css/navigation.css">
    <link rel="stylesheet" href="css/form.css">

    <!-- Link to jQuery -->
    <script src="js/j_query_min.js"></script>


</head>

<body>

    <div class="wrapper">


        <div class="logo">
                <a href="index.php"><img class="responsive" src="images/icon.png"
                alt="s" ></a>
        </div> <!-- / logo-->

            <div class="top-title">
                <h2>Benny's BarberShop</h2>
            </div>  <!-- / top title -->


            <div class="header">
                <div class="menu-header">
                

                <i class="fa fa-bars"></i>

                <div class="menu-content">
                    <ul>
                        <li><a class="nav" href="index.php">Home</a></li>
                        <li><a class="nav dropbtn" href="#">Gallery<i class="fa fa-chevron-down"></i></a>
                        <ul class="dropdown">
                                <li><a class="nav" href="index.php?page=fade">Fade</a></li>
                                <li><a class="nav" href="index.php?page=braid">Braid</a></li>
                                <li><a class="nav" href="index.php?page=colour">Colour</a></li>
                                
                        </ul>

                        </li>   <!-- / gallery dropdown -->


                        <li><a href="index.php?page=about">About</a></li>
                        <li><a href="index.php?page=links">Links</a></li>
                        <li><a href="index.php?page=contact">Contact</a></li>
                    </ul>
                </div> <!-- menu-content-->

                </div> <!-- menu-header-->
            </div> <!-- header-->

    

        <!-- 'Main Div goes here' -->
        <?php

        if (!isset($_REQUEST['page'])) {
            include("home.php");
        }

        else {
            // prevents users from navigating through file system
            $page = preg_replace('/[^0-9a-zA-Z]-/', '', $_REQUEST['page']);
            include("$page.php");
        }

        ?>



        <div class="box footer">
            N Panapa 2025
        </div> <!-- / footer -->

    </div> <!-- / wrapper -->

    <!-- Add jQuery to bottom of pages!! -->
    <script>
    $(document).ready(function() {

        // Dropdown for Gallery menu
        $('.dropbtn').click(function() {
            $('.dropdown').toggleClass('display');
        });

        // Hamburger menu toggle
        $('.fa-bars').click(function() {
            $('.menu-content').toggleClass('show-menu');
        });
    });
    </script>

    <!-- Lightbox Javascript... -->
    <script src="js/simple-lightbox.min.js"></script>

    <script>
        (function(){
            var $gallery = new SimpleLightbox('.gallery a', {})
        })();
    </script>


</body>
